:: Installation Script
@echo off
setlocal enabledelayedexpansion

cd /d %~dp0

set YES=0
set APP_NAME=Video Downloader
set VERSION=1.0
set INSTALL_DIR=%SystemDrive%\Program Files\%APP_NAME%
set EXECUTABLE=Downloader.exe

::Already installed?
if exist "%INSTALL_DIR%" (
    echo App already installed.
    echo If this was an error, please uninstall the app and try again:
    echo To uninstall run UNINSTALL.bat at %INSTALL_DIR%\UNINSTALL.bat
    exit /b 1
)

:: Admin
CALL NET SESSION >nul 2>&1
if not %errorlevel% == 0 (
    echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
    echo UAC.ShellExecute "%~s0", "%*", "", "runas", 1 >> "%temp%\getadmin.vbs"
    "%temp%\getadmin.vbs"
    del "%temp%\getadmin.vbs"
    exit /b
)


::Arguments

:parse_arguments
if "%~1"=="" goto end_parse_arguments

set option=%~1
shift

if /I "%option%"=="-h" (
    goto usage
) else if /I "%option%"=="--help" (
    goto usage
) else if /I "%option%"=="-y" (
    set YES=1
) else if /I "%option%"=="--yes" (
    set YES=1
) else (
    echo Unknown option: %option%
    goto usage
)

goto parse_arguments

:end_parse_arguments


:: Check if the system is running 64-bit or 32-bit
if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
    set "arch=64"
) else (
    if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
        set "arch=64"
    ) else (
        set "arch=32"
    )
)


:: Check if FFmpeg can be installed
if "%arch%"=="64" (
    if /I NOT "%YES%"=="1" (
        choice /C YN /M "Do you want to proceed with the installation?"
    )
    if errorlevel 2 (
        echo Installation cancelled
        pause
        exit /b 2
    ) else (
        echo Proceeding with installation of 64-bit version of FFmpeg and choco
    )
) else (
    echo FFmpeg cannot be installed in 32-bit systems with chocolatey
    echo Try using another package manager such as WinGet
    pause
    exit /b 3
)

::Already installed?
where choco >nul 2>nul

if %errorlevel% equ 0 (
    echo Chocolatey is already installed.
) else (
    echo Chocolatey is not installed.
    echo Attempting to install Chocolatey.
    if "%YES%"=="1" (
        echo y | @"%SystemRoot%\System32\WindowsPowerShell\v1.0\powershell.exe" -NoProfile -InputFormat None -ExecutionPolicy Bypass -Command "iex ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))" && SET "PATH=%PATH%;%ALLUSERSPROFILE%\chocolatey\bin"
    ) else (
        @"%SystemRoot%\System32\WindowsPowerShell\v1.0\powershell.exe" -NoProfile -InputFormat None -ExecutionPolicy Bypass -Command "iex ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))" && SET "PATH=%PATH%;%ALLUSERSPROFILE%\chocolatey\bin"
    )
)

::Check
where choco >nul 2>nul

if %errorlevel% equ 0 (
    echo Chocolatey is definitely installed.
) else (
    echo Chocolatey is not installed.
    echo Failed to install.
    exit /b 4
)

::Already installed?
where ffmpeg >nul 2>nul

if %errorlevel% equ 0 (
    echo FFMPEG is already installed.
) else (
    echo FFMPEG is not installed.
    echo Attempting to install FFMPEG.
    :: Download and install FFmpeg
    if "%YES%"=="1" (
        choco install ffmpeg -y
    ) else (
        choco install ffmpeg
    )
)

::Check
where ffmpeg >nul 2>nul

if %errorlevel% equ 0 (
    echo FFMPEG is definitely installed.
) else (
    echo FFMPEG is not installed.
    echo Failed to install.
    exit /b 5
)

cd /d %~dp0

mkdir "%INSTALL_DIR%"

xcopy /s /e /y * "%INSTALL_DIR%" >nul

if /I NOT "%YES%"=="1" (
    choice /C YN /M "Do you want to create a desktop shortcut?"
)
if errorlevel 2 (
    echo There will be no desktop shortcut created!!
    goto noshortcut
) else (
    echo Creating desktop shortcut
    goto shortcut
)
:shortcut
::Desktop Shortcut

:: Set the variables for the shortcut
set ExecutableFile="%INSTALL_DIR%\runapp.bat"
set IconFile="%INSTALL_DIR%\assets\other versions\video downloader.ico"
set ShortcutFile="%USERPROFILE%\Desktop\%APP_NAME%.lnk"

echo Creating shortcut to %ExecutableFile%...

(
    echo Set objShell = CreateObject^("WScript.Shell"^)
    echo Set objShortcut = objShell.CreateShortcut^(%ShortcutFile%^)
    echo objShortcut.TargetPath = %ExecutableFile%
    echo objShortcut.IconLocation = %IconFile%
    echo objShortcut.Save
) > CreateShortcut.vbs

cscript //nologo CreateShortcut.vbs
del CreateShortcut.vbs

echo Shortcut created.


:noshortcut
echo Successfully installed %APP_NAME% to %INSTALL_DIR%

pause
goto :eof

:usage
echo Usage: INSTALL_VD.bat [-h|--help] [-y|--yes]
echo. 
echo Options:
echo   -h, --help       Display this help message
echo   -y, --yes        Answer yes to all prompts
exit /b